/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly;

import java.io.File;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.deadly.DeadlyModuleClient;
import shadows.apotheosis.deadly.DeadlyModuleEvents;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.loot.LootCategory;
import shadows.apotheosis.deadly.loot.LootRarity;
import shadows.apotheosis.deadly.loot.affix.Affix;
import shadows.apotheosis.deadly.loot.affix.AttributeAffix;
import shadows.apotheosis.util.NameHelper;
import shadows.placebo.config.Configuration;

public class DeadlyModule {
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Deadly");
    public static final boolean DEBUG = false;

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisConstruction e) {
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        this.reload(null);
        MinecraftForge.EVENT_BUS.register((Object)new DeadlyModuleEvents());
        MinecraftForge.EVENT_BUS.addListener(this::reload);
    }

    @SubscribeEvent
    public void register(RegistryEvent.Register<Feature<?>> e) {
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<BlockEntityType<?>> e) {
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
    }

    @SubscribeEvent
    public void registry(NewRegistryEvent e) {
        RegistryBuilder build = new RegistryBuilder();
        build.setName(new ResourceLocation("apotheosis", "affixes"));
        build.setType(Affix.class);
        e.create(build, r -> {
            Affix.REGISTRY = (ForgeRegistry)r;
        });
    }

    @SubscribeEvent
    public void attribs(RegistryEvent.Register<Attribute> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Attribute[]{(Attribute)new RangedAttribute("apotheosis:draw_speed", 1.0, 1.0, 1024.0).m_22084_(true).setRegistryName("draw_speed"), (Attribute)new RangedAttribute("apotheosis:crit_chance", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("crit_chance"), (Attribute)new RangedAttribute("apotheosis:crit_damage", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("crit_damage"), (Attribute)new RangedAttribute("apotheosis:cold_damage", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("cold_damage"), (Attribute)new RangedAttribute("apotheosis:fire_damage", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("fire_damage"), (Attribute)new RangedAttribute("apotheosis:life_steal", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("life_steal"), (Attribute)new RangedAttribute("apotheosis:piercing", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("piercing"), (Attribute)new RangedAttribute("apotheosis:current_hp_damage", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("current_hp_damage"), (Attribute)new RangedAttribute("apotheosis:overheal", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("overheal")});
    }

    @SubscribeEvent
    public void affixes(RegistryEvent.Register<Affix> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Affix[]{new AttributeAffix.Builder(LootRarity.COMMON).with(Attributes.f_22276_, AttributeModifier.Operation.ADDITION, level -> Float.valueOf(0.5f + (float)Math.round(level.floatValue() * 3.0f) / 2.0f)).types(LootCategory::isDefensive).build("common_max_hp"), new AttributeAffix.Builder(LootRarity.COMMON).with(Attributes.f_22284_, AttributeModifier.Operation.ADDITION, 0.5f, 2.0f).types(LootCategory::isDefensive).build("common_armor"), new AttributeAffix.Builder(LootRarity.COMMON).with(Attributes.f_22281_, AttributeModifier.Operation.ADDITION, 0.5f, 2.0f).build("common_dmg"), new AttributeAffix.Builder(LootRarity.COMMON).with(Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.05f, 0.15f).build("common_mvspd"), new AttributeAffix.Builder(LootRarity.COMMON).with(Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.1f, 0.25f).build("common_aspd"), new AttributeAffix.Builder(LootRarity.COMMON).with(Attributes.f_22282_, AttributeModifier.Operation.ADDITION, 0.25f, 0.5f).build("common_kb"), new AttributeAffix.Builder(LootRarity.COMMON).with((Supplier<Attribute>)ForgeMod.REACH_DISTANCE, AttributeModifier.Operation.ADDITION, level -> Float.valueOf(0.5f + (float)Math.round(level.floatValue() * 3.0f) / 2.0f)).build("common_reach")});
    }

    @SubscribeEvent
    public void client(FMLClientSetupEvent e) {
        e.enqueueWork(DeadlyModuleClient::init);
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        Configuration mainConfig = new Configuration(new File(Apotheosis.configDir, "deadly.cfg"));
        Configuration nameConfig = new Configuration(new File(Apotheosis.configDir, "names.cfg"));
        DeadlyConfig.load(mainConfig);
        NameHelper.load(nameConfig);
        if (e == null && mainConfig.hasChanged()) {
            mainConfig.save();
        }
        if (e == null && nameConfig.hasChanged()) {
            nameConfig.save();
        }
    }

    public static void debugLog(BlockPos pos, String name) {
    }
}

